/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SocketUtil {
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    private SocketUtil() {
    }

    public static int findFreePort(InetAddress address) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0, 0, address);
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public static int findFreePort(InetAddress address, int start, int end) {
        ServerSocket socket = null;
        try {
            int port = start;
            while (port <= end) {
                try {
                    socket = new ServerSocket(port, 0, address);
                    socket.setReuseAddress(true);
                    int n = socket.getLocalPort();
                    return n;
                }
                catch (IOException iOException) {
                    ++port;
                }
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public static boolean isValidIPv4(String ip) {
        Matcher ipMatcher = IPV4_PATTERN.matcher(ip);
        if (ipMatcher.matches()) {
            String[] segments;
            String[] stringArray = segments = ip.split("\\.");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                try {
                    int segment = Integer.parseInt(s);
                    if (segment < 0 || segment > 255) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static InetAddress[] getLocalAddresses() {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface iface = e1.nextElement();
                Enumeration<InetAddress> e2 = iface.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress inetAddr = e2.nextElement();
                    if (!(inetAddr instanceof Inet4Address) || addrs.contains(inetAddr)) continue;
                    if (!inetAddr.isLoopbackAddress()) {
                        addrs.add(0, inetAddr);
                        continue;
                    }
                    addrs.add(inetAddr);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    public static InetAddress[] getNonLoopbackLocalAdresses() {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        InetAddress[] inetAddressArray = SocketUtil.getLocalAddresses();
        int n = inetAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress inetAddr = inetAddressArray[n2];
            if (!inetAddr.isLoopbackAddress()) {
                if (SocketUtil.isPublic(inetAddr)) {
                    addrs.add(0, inetAddr);
                } else {
                    addrs.add(inetAddr);
                }
            }
            ++n2;
        }
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    private static boolean isPublic(InetAddress inetAddress) {
        String hostAddress = inetAddress.getHostAddress();
        if (hostAddress.startsWith("10.") || hostAddress.startsWith("192.168.") || hostAddress.startsWith("169.254.") || hostAddress.startsWith("127.")) {
            return false;
        }
        if (hostAddress.startsWith("172.")) {
            return inetAddress.getAddress()[1] < 16 || inetAddress.getAddress()[1] > 31;
        }
        return true;
    }
}

